
import unittest


class Test06(unittest.TestCase):
    def test_01_brez_dodatkov(self):
        self.assertEqual("Kreacher", brez_dodatkov("Mr. Kreacher"))
        self.assertEqual("Molly Weasley", brez_dodatkov("Mrs. Molly Weasley"))
        self.assertEqual("Rolanda Hooch", brez_dodatkov("Madame Rolanda Hooch"))
        self.assertEqual("Martin Luther", brez_dodatkov("Martin Luther Jr."))
        self.assertEqual("Cygnus Black", brez_dodatkov("Cygnus Black III"))
        self.assertEqual("Sirius Black", brez_dodatkov("Sirius Black I"))

    def test_02_po_priimkih(self):
        popr = po_priimkih()
        self.assertEqual({'Hermione'}, popr["Granger"])
        self.assertEqual({'Cedric', 'Amos'}, popr["Diggory"])
        self.assertEqual({'Albus', 'Ariana', 'Percival', 'Kendra', 'Aberforth'}, popr["Dumbledore"])
        self.assertEqual({'Harry', 'Charlus', 'Lily', 'James', 'Albus'}, popr["Potter"])
        self.assertEqual({'Arthur', 'Bilius', 'Bill', 'Charlie', 'Dominique', 'Fred',
                          'George', 'Ginny', 'Louis', 'Molly', 'Percy', 'Ron', 'Roxanne',
                          'Septimus', 'Victoire'}, popr["Weasley"])
        self.assertFalse("Kreacher" in popr)

    def test_03_unikatni_priimki(self):
        self.assertEqual(
            {'Abbott', 'Bagman', 'Bagnold', 'Bagshot', 'Bard', 'Baron', 'Belby', 'Bell', 'Binns', 'Bloxam', 'Bode',
             'Boot', 'Bragge', 'Brown', 'Bryce', 'Burbage', 'Cattermole', 'Chang', 'Clearwater', 'Coote', 'Corner',
             'Creevey', 'Cresswell', 'Davies', 'Dawlish', 'Derwent', 'Diggle', 'Dippet', 'Dodderidge', 'Doge',
             'Dolohov', 'Edgecombe', 'Ever-Ready', 'Evil', 'Figg', 'Filch', 'Finch-Fletchley', 'Finnigan', 'First',
             'Flamel', 'Fletcher', 'Flitwick', 'Friar', 'Fudge', 'Gamp', 'Goldstein', 'Goyle', 'Granger',
             'Granger-Weasley', 'Greyback', 'Grindelwald', 'Grubbly-Plank', 'Gryffindor', 'Hagrid', 'Hat', 'Hitchens',
             'Hooch', 'Hopkirk', 'Hufflepuff', 'Johnson', 'Jones', 'Jordan', 'Jorkins', 'Karkaroff', 'Kettleburn',
             'Krum', 'Lady', 'Leach', 'Lufkin', 'Macnair', 'Maxime', 'McGonagall', 'McKinnon', 'McLaggen', 'Moody',
             'Myrtle', 'Nick', 'Ogden', 'Ollivander', 'Orpington', 'Parkinson', 'Peakes', 'Pettigrew', 'Pince',
             'Polkiss', 'Pomfrey', 'Prang', 'Prewett', 'Prince', 'Quirrell', 'Riddle', 'Robins', 'Rookwood', 'Runcorn',
             'Scrimgeour', 'Shacklebolt', 'Shunpike', 'Sinistra', 'Skeeter', 'Skrewt', 'Sloper', 'Slughorn',
             'Slytherin', 'Spavin', 'Spinnet', 'Sprout', 'Stump', 'Thicknesse', 'Thomas', 'Umbridge', 'Vance', 'Vane',
             'Vector', 'Voldemort', 'Whisp', 'Willow', 'Wood', 'Wright', 'Zabini'},
            unikatni_priimki())

    def test_04_imena(self):
        self.assertEqual(
            {'Aberforth', 'Abraxas', 'Alastor', 'Albert', 'Albus', 'Alecto', 'Alice', 'Alicia', 'Alphard', 'Amelia',
             'Amos', 'Amycus', 'Andromeda', 'Angelina', 'Anthony', 'Antioch', 'Antonin', 'Arabella', 'Arcturus',
             'Argus', 'Ariana', 'Armando', 'Artemisia', 'Arthur', 'Astoria', 'Augusta', 'Augustus', 'Aurora',
             'Barberus', 'Barty', 'Bathilda', 'Beatrix', 'Beedle', 'Bellatrix', 'Belvina', 'Bertha', 'Bilius', 'Bill',
             'Blaise', 'Blast-ended', 'Bloody', 'Bob', 'Bowman', 'Broderick', 'Cadmus', 'Callidora', 'Caractacus',
             'Caspar', 'Cassandra', 'Cassiopeia', 'Cedrella', 'Cedric', 'Charis', 'Charity', 'Charlie', 'Charlus',
             'Cho', 'Colin', 'Corban', 'Cormac', 'Cornelius', 'Cuthbert', 'Cygnus', 'Daisy', 'Damocles', 'Daphne',
             'Dean', 'Dedalus', 'Demelza', 'Dexter', 'Dilys', 'Dirk', 'Dolores', 'Dominique', 'Dorea', 'Draco',
             'Druella', 'Dudley', 'Eileen', 'Elladora', 'Elphias', 'Emeric', 'Emmeline', 'Ernie', 'Ethelred', 'Evan',
             'Evangeline', 'Faris', 'Fat', 'Fenrir', 'Filius', 'Fleur', 'Florian', 'Frank', 'Fred', 'Gabrielle',
             'Garrick', 'Gellert', 'George', 'Ginny', 'Godric', 'Gregory', 'Grogan', 'Gwenog', 'Hannah', 'Harfang',
             'Harry', 'Helena', 'Helga', 'Hepzibah', 'Herbert', 'Hermione', 'Hesper', 'Horace', 'Ignatius', 'Ignotus',
             'Igor', 'Irma', 'Isla', 'Jack', 'James', 'Jimmy', 'John', 'Justin', 'Katie', 'Kendra', 'Kennilworthy',
             'King', 'Kingsley', 'Lavender', 'Lee', 'Lily', 'Lord', 'Louis', 'Lucius', 'Lucretia', 'Ludo', 'Luna',
             'Lycoris', 'Lysandra', 'Mafalda', 'Marcus', 'Marietta', 'Marius', 'Marlene', 'Marvolo', 'Melania',
             'Merope', 'Michael', 'Millicent', 'Minerva', 'Moaning', 'Molly', 'Morfin', 'Mundungus', 'Narcissa',
             'Nearly', 'Neville', 'Newt', 'Nicolas', 'Nobby', 'Nymphadora', 'Oliver', 'Olympe', 'Orion', 'Padma',
             'Pansy', 'Parvati', 'Penelope', 'Percival', 'Percy', 'Peter', 'Petunia', 'Phineas', 'Piers', 'Pius',
             'Pollux', 'Pomona', 'Poppy', 'Quirinus', 'Rabastan', 'Reginald', 'Regulus', 'Remus', 'Rita', 'Ritchie',
             'Rodolphus', 'Roger', 'Rolanda', 'Rolf', 'Romilda', 'Ron', 'Rose', 'Rowena', 'Roxanne', 'Rubeus', 'Rufus',
             'Salazar', 'Scorpius', 'Seamus', 'Septima', 'Septimus', 'Severus', 'Silvanus', 'Sirius', 'Sorting', 'Stan',
             'Susan', 'Sybill', 'Ted', 'Terry', 'Thorfinn', 'Tobias', 'Tom', 'Ursula', 'Vernon', 'Victoire', 'Viktor',
             'Vincent', 'Violetta', 'Walburga', 'Walden', 'Whomping', 'Wilhelmina', 'Xenophilius', 'Zacharias'},
            imena())

class Test07(unittest.TestCase):
    def test_01_podvojena_imena(self):
        self.assertEqual(
            {'Ernie', 'Marcus', 'Arcturus', 'Granger', 'Irma', 'Barty', 'James', 'Evans', 'Millicent', 'Fat', 'Sirius',
             'Frank', 'Albus', 'Bob', 'Regulus', 'Fred', 'Lily', 'Ted', 'Cygnus', 'Phineas'},
            podvojena_imena())

    def test_02_omembe(self):
        s = "Albus saw how Harry walked away with Ron and Harry was saying something".split()

        self.assertEqual([0], omembe(s, "Albus"))
        self.assertEqual([3, 9], omembe(s, "Harry"))
        self.assertEqual([7], omembe(s, "Ron"))

        potter6 = open("potter6-besede.txt", encoding="utf-8").read().strip().split()
        self.assertEqual([], omembe(potter6, "Hooch"))
        self.assertEqual([], omembe(potter6, "Fudge"))
        self.assertEqual([616, 707, 720, 828, 861, 885, 952, 1004, 1009, 1068, 1143, 1344, 1377, 1497, 1558, 1591,
                          1608, 1683, 1916, 1947, 1992, 2116, 2148, 2189, 2226, 2248, 2317, 2381, 2408, 2469, 2502,
                          2542, 2581, 2632, 2656, 2675, 2688, 2767, 2832, 2890, 2922, 3027, 3130, 3192, 3249, 3337,
                          3394, 3504, 3533, 3564, 3657, 3711, 3777, 3876, 3931, 4028, 4089, 4192, 4245, 4288, 4372,
                          4480, 4519, 4961, 4973, 5061, 10459, 15671, 15731, 80629, 88120, 89189, 89469, 91559, 91570,
                          166062],
                          omembe(potter6, "Cornelius"))
        self.assertEqual(2671, len(omembe(potter6, "Harry")))

class Test08(unittest.TestCase):
    def test_01_po_blokih(self):
        np.testing.assert_equal(
            [1, 1, 0, 1],
            po_blokih("Albus saw Harry how Harry walked away with Ron and Harry was saying something".split(),
                      "Harry",
                      3))
        np.testing.assert_equal(
            [2, 0],
            po_blokih("Albus saw Harry how Harry walked away with Ron and Harry was saying something".split(),
                      "Harry", 5))

        potter6 = open("potter6-besede.txt", encoding="utf-8").read().strip().split()
        np.testing.assert_equal(
            [7, 146, 154, 181, 177, 129, 154, 183, 167, 164, 205, 135, 181, 189, 220, 151],
            po_blokih(potter6, "Harry", 10000))
        np.testing.assert_equal(
            [72, 0, 3, 0, 52, 5, 7, 1, 45, 11, 13, 17, 0, 34, 18, 67],
            po_blokih(potter6, "Severus", 10000))

    def test_02_imena_po_blokih(self):
        potter6 = open("potter6-besede.txt", encoding="utf-8").read().strip().split()
        imena = ["Ron", "Hermione", "Ginny", "Horace", "Draco", "Albus", "Severus", "Cornelius"]
        pojavitve = imena_po_blokih(potter6, imena, 2000)
        np.testing.assert_equal(
            pojavitve,
            [[0, 0, 0, 0, 0, 0, 0, 21], [0, 0, 0, 0, 0, 2, 0, 34], [0, 0, 0, 0, 0, 2, 2, 11], [0, 0, 0, 0, 0, 8, 34, 0],
             [0, 0, 0, 0, 13, 4, 36, 0], [0, 0, 0, 0, 0, 13, 0, 1], [0, 0, 0, 0, 0, 32, 0, 0],
             [0, 1, 0, 0, 0, 37, 0, 2], [0, 0, 0, 24, 0, 37, 0, 0], [2, 0, 0, 23, 0, 23, 0, 0],
             [20, 1, 0, 3, 0, 19, 3, 0], [38, 10, 7, 2, 0, 1, 0, 0], [36, 35, 9, 0, 0, 6, 0, 0],
             [33, 13, 6, 0, 0, 2, 0, 0], [24, 15, 3, 0, 10, 1, 0, 0], [22, 14, 9, 0, 13, 0, 0, 0],
             [35, 24, 3, 0, 11, 0, 0, 0], [16, 4, 4, 2, 5, 1, 0, 0], [1, 0, 11, 28, 6, 1, 0, 0],
             [4, 3, 0, 2, 27, 2, 0, 0], [8, 11, 1, 1, 3, 5, 20, 0], [24, 16, 0, 4, 5, 12, 4, 0],
             [11, 9, 0, 2, 1, 1, 25, 0], [13, 21, 0, 21, 5, 3, 1, 0], [9, 11, 2, 7, 7, 4, 2, 0],
             [0, 0, 0, 1, 0, 21, 0, 0], [0, 0, 0, 0, 0, 2, 0, 0], [12, 12, 0, 1, 0, 18, 0, 0],
             [23, 18, 2, 1, 1, 2, 0, 0], [19, 27, 1, 7, 1, 1, 5, 0], [21, 21, 4, 3, 3, 3, 4, 0],
             [19, 21, 2, 6, 0, 2, 0, 0], [16, 20, 0, 1, 14, 8, 2, 0], [0, 0, 0, 0, 2, 37, 1, 0],
             [0, 0, 0, 0, 0, 39, 0, 0], [9, 12, 0, 1, 1, 18, 0, 0], [30, 9, 22, 0, 0, 0, 0, 0],
             [44, 11, 10, 0, 3, 0, 0, 0], [32, 18, 7, 1, 1, 0, 0, 0], [11, 25, 3, 1, 1, 0, 1, 0],
             [10, 20, 1, 10, 0, 1, 5, 1], [15, 0, 2, 7, 27, 1, 22, 0], [27, 3, 2, 0, 6, 8, 15, 0],
             [30, 2, 3, 0, 0, 0, 3, 0], [11, 0, 4, 0, 0, 7, 0, 3], [15, 17, 3, 0, 5, 14, 5, 2],
             [0, 0, 0, 0, 2, 15, 2, 0], [2, 2, 0, 15, 0, 21, 0, 0], [16, 20, 1, 25, 1, 2, 2, 0],
             [9, 4, 0, 1, 15, 0, 2, 0], [45, 1, 0, 6, 6, 0, 1, 0], [27, 8, 10, 25, 0, 7, 0, 0],
             [14, 6, 2, 1, 11, 8, 11, 0], [11, 0, 6, 0, 8, 0, 1, 0], [16, 13, 3, 2, 4, 10, 0, 0],
             [3, 0, 0, 5, 0, 18, 0, 0], [0, 1, 0, 0, 0, 21, 0, 0], [8, 13, 0, 3, 0, 26, 3, 0],
             [16, 23, 0, 6, 18, 1, 2, 0], [16, 9, 0, 2, 5, 1, 12, 0], [26, 30, 1, 4, 6, 5, 0, 0],
             [18, 17, 2, 22, 7, 1, 0, 0], [2, 1, 0, 28, 0, 1, 0, 0], [0, 0, 0, 27, 0, 10, 0, 0],
             [0, 0, 0, 9, 0, 12, 0, 0], [0, 0, 0, 0, 0, 16, 0, 0], [12, 17, 3, 2, 0, 8, 0, 0],
             [13, 3, 9, 3, 16, 0, 11, 0], [7, 13, 7, 0, 3, 0, 15, 0], [12, 14, 14, 1, 1, 1, 8, 0],
             [0, 0, 0, 0, 0, 19, 10, 0], [5, 8, 1, 0, 5, 29, 7, 0], [0, 0, 0, 0, 0, 38, 1, 0],
             [1, 1, 1, 0, 0, 39, 0, 0], [0, 0, 0, 0, 0, 32, 0, 0], [2, 1, 0, 0, 18, 38, 5, 0],
             [0, 1, 0, 1, 36, 35, 2, 0], [1, 0, 2, 0, 11, 10, 21, 0], [0, 0, 0, 0, 0, 12, 20, 0],
             [11, 5, 14, 0, 6, 12, 19, 0], [21, 6, 5, 2, 1, 7, 9, 0], [9, 2, 2, 4, 1, 12, 2, 0],
             [9, 12, 4, 3, 5, 9, 9, 0], [3, 4, 10, 0, 0, 14, 0, 1]]
        )

        imena = ["Severus", "Harry", "Ron", "Hermione", "Ginny", "Horace", "Draco", "Albus", "Cornelius"]
        pojavitve = po_blokih(imena, potter6, 2000)
        try:
            from matplotlib import pyplot as plt
            fig, ax = plt.subplots()
            plt.imshow(pojavitve / np.max(pojavitve), aspect="auto")
            ax.set_xticks(np.arange(len(imena)))
            ax.set_xticklabels(imena)
            ax.set_fontsize = 6
            plt.savefig("pojavitve.png")
            plt.show()
        except Exception:
            pass

class Test09(unittest.TestCase):
    def test_01_sosed(self):
        self.assertEqual(
            {"Ron": 2, "Romilda": 1},
            sosed("Harry and Ron met Romilda and Romilda asked Harry about Ron".split(), "Harry", 2))
        self.assertEqual(
            {"Ron": 2, "Romilda": 3},
            sosed("Harry and Ron met Romilda and Romilda asked Harry about Ron".split(), "Harry", 4))

        potter6 = open("potter6-besede.txt", encoding="utf-8").read().strip().split()
        self.assertEqual(
            {'Albus': 1, 'Argus': 1, 'Cormac': 1, 'Dean': 1, 'Draco': 4, 'Eileen': 7, 'Ernie': 1, 'Fenrir': 1,
             'Ginny': 20, 'Godric': 1, 'Harry': 76, 'Horace': 5, 'Katie': 1, 'Lavender': 4, 'Luna': 2, 'Minerva': 1,
             'Mundungus': 1, 'Nymphadora': 1, 'Parvati': 2, 'Poppy': 1, 'Remus': 2, 'Ron': 136, 'Rubeus': 7, 'Rufus': 1,
             'Severus': 1, 'Sirius': 1, 'Stan': 1, 'Viktor': 1},
            sosed(potter6, "Hermione", 2))

        self.assertEqual(
            {'Alastor': 1, 'Albus': 58, 'Amycus': 3, 'Arabella': 1, 'Arthur': 10, 'Bill': 58, 'Charlie': 2, 'Cho': 1,
             'Cornelius': 1, 'Dean': 1, 'Draco': 10, 'Eileen': 19, 'Ernie': 1, 'Fat': 1, 'Fenrir': 25, 'Filius': 8,
             'Fleur': 38, 'Florian': 1, 'Fred': 10, 'Garrick': 1, 'George': 8, 'Ginny': 39, 'Godric': 1, 'Harry': 185,
             'Hermione': 33, 'Igor': 2, 'James': 12, 'Kingsley': 1, 'Lavender': 2, 'Lord': 9, 'Luna': 4, 'Minerva': 32,
             'Molly': 4, 'Nearly': 3, 'Neville': 8, 'Nymphadora': 57, 'Olympe': 1, 'Percy': 5, 'Peter': 1, 'Poppy': 10,
             'Regulus': 2, 'Ron': 148, 'Rubeus': 4, 'Rufus': 6, 'Seamus': 1, 'Severus': 72, 'Sirius': 12, 'Tom': 1},
            sosed(potter6, "Remus", 100))

class Test10(unittest.TestCase):
    def test_01_sovpadanje(self):
        s = "Harry and Ron met Romilda and Romilda asked Harry about Ron".split()
        self.assertEqual(6, sovpadanje(s, "Harry", "Ron", 2))
        self.assertEqual(4, sovpadanje(s, "Harry", "Romilda", 2))
        self.assertEqual(4, sovpadanje(s, "Romilda", "Ron", 2))


        self.assertEqual(2, sovpadanje(s, "Harry", "Ron", 1))
        self.assertEqual(1, sovpadanje(s, "Harry", "Romilda", 1))
        self.assertEqual(1, sovpadanje(s, "Romilda", "Ron", 1))

        self.assertEqual(11, sovpadanje(s, "Harry", "Ron", 3))
        self.assertEqual(8, sovpadanje(s, "Harry", "Romilda", 3))
        self.assertEqual(8, sovpadanje(s, "Romilda", "Ron", 3))

        potter6 = open("potter6-besede.txt", encoding="utf-8").read().strip().split()
        self.assertEqual(879, sovpadanje(potter6, "Cornelius", "Harry", 50))
        self.assertEqual(1164, sovpadanje(potter6, "Cornelius", "Rufus", 50))
        self.assertEqual(42245, sovpadanje(potter6, "Albus", "Harry", 50))
        self.assertEqual(48532, sovpadanje(potter6, "Harry", "Ron", 50))
        self.assertEqual(39282, sovpadanje(potter6, "Harry", "Hermione", 50))


if __name__ == "__main__":
    unittest.main()
