
import unittest
import json
import re
import warnings

warnings.simplefilter("ignore", ResourceWarning)


class ResponseMock:
    def __init__(self, data):
        self.data = data.encode("utf-8")

    def read(self):
        return self.data


jsoni = json.load(open("osebe.json", encoding="utf-8"))


def urlopen(url):
    try:
        return ResponseMock(jsoni[url])
    except:
        from urllib import request
        return request.urlopen(url)


def samo_besede(s):
    return " ".join(re.findall(r"\w(?:\w|(?:[\-'’]\w))*", s))


primarna = {
    'Potter': 'Harry',
    'Diggory': 'Cedric',
    'Dursley': 'Vernon',
    'Longbottom': 'Neville',
    'Tonks': 'Nymphadora',
    'Rowle': 'Damocles',
    'Yaxley': 'Corban',
    'Malfoy': 'Draco',
    'Macmillan': 'Ernie',
    'Weasley': 'Ron',
    'Patil': 'Parvati',
    'Black': 'Sirius',
    'Burke': 'Caractacus',
    'Greengrass': 'Astoria',
    'Dumbledore': 'Albus',
    'Rosier': 'Evan',
    'Snape': 'Severus',
    'Peverell': 'Ignotus',
    'Fortescue': 'Florian',
    'Scamander': 'Newt',
    'Crouch': 'Barty',
    'Delacour': 'Fleur',
    'Lovegood': 'Luna',
    'Flint': 'Marcus',
    'Bulstrode': 'Millicent',
    'Gaunt': 'Marvolo',
    'Lupin': 'Remus',
    'Carrow': 'Amycus',
    'Ravenclaw': 'Rowena',
    'Trelawney': 'Sybill',
    'Lestrange': 'Bellatrix',
    'Smith': 'Zacharias',
    'Bones': 'Amelia',
    'Crabbe': 'Vincent'
}


class Test(unittest.TestCase):
    def setUp(self):
        super().setUp()
        self.maxDiff = None
        warnings.simplefilter("ignore", ResourceWarning)


class Test06(Test):
    def test_01_osebe(self):
        self.assertEqual(280, len(osebe))
        self.assertEqual("http://www.wikidata.org/entity/Q176772", osebe["Severus Snape"])
        self.assertEqual("http://www.wikidata.org/entity/Q717594", osebe["James Potter"])
        self.assertEqual("http://www.wikidata.org/entity/Q3270426", osebe["Kreacher"])

    def test_02_brez_dodatkov(self):
        self.assertEqual("Kreacher", brez_dodatkov("Mr. Kreacher"))
        self.assertEqual("Molly Weasley", brez_dodatkov("Mrs. Molly Weasley"))
        self.assertEqual("Rolanda Hooch", brez_dodatkov("Madame Rolanda Hooch"))
        self.assertEqual("Martin Luther", brez_dodatkov("Martin Luther Jr."))
        self.assertEqual("Cygnus Black", brez_dodatkov("Cygnus Black III"))
        self.assertEqual("Sirius Black", brez_dodatkov("Sirius Black I"))

    def test_03_je_stevilka_poglavja(self):
        self.assertTrue(je_stevilka_poglavja("— CHAPTER ONE —"))
        self.assertTrue(je_stevilka_poglavja("— CHAPTER TWENTY —"))
        self.assertTrue(je_stevilka_poglavja("— CHAPTER TWENTY-ONE —"))
        self.assertFalse(je_stevilka_poglavja(" WILL AND WON’T 43"))
        self.assertFalse(je_stevilka_poglavja("SCRIMGEOUR SUCCEEDS FUDGE"))
        self.assertFalse(je_stevilka_poglavja("44 HARRY POTTER"))
        self.assertFalse(je_stevilka_poglavja("Spinner’s End"))
        self.assertFalse(je_stevilka_poglavja("He had been standing alone in this very office, savouring"))

    def test_04_po_priimkih(self):
        popr = po_priimkih()
        self.assertEqual({'Hermione'}, popr["Granger"])
        self.assertEqual({'Cedric', 'Amos'}, popr["Diggory"])
        self.assertEqual({'Albus', 'Ariana', 'Percival', 'Kendra', 'Aberforth'}, popr["Dumbledore"])
        self.assertEqual({'Harry', 'Charlus', 'Lily', 'James', 'Albus'}, popr["Potter"])
        self.assertEqual({'Arthur', 'Bilius', 'Bill', 'Charlie', 'Dominique', 'Fred',
                          'George', 'Ginny', 'Louis', 'Molly', 'Percy', 'Ron', 'Roxanne',
                          'Septimus', 'Victoire'}, popr["Weasley"])
        self.assertFalse("Kreacher" in popr)

    def test_05_imena_poglavij(self):
        self.assertEqual(
            ['The Other Minister', 'Spinner’s End', 'Will and Won’t'],
            imena_poglavij("potter6-zacetek.txt"))
        self.assertEqual(
            ['The Other Minister', 'Spinner’s End', 'Will and Won’t',
             'Horace Slughorn', 'An Excess of Phlegm', 'Draco’s Detour',
             'The Slug Club', 'Snape Victorious', 'The Half-Blood Prince',
             'The House of Gaunt', 'Hermione’s Helping Hand', 'Silver and Opals',
             'The Secret Riddle', 'Felix Felicis', 'The Unbreakable Vow',
             'A Very Frosty Christmas', 'A Sluggish Memory', 'Birthday Surprises',
             'Elf Tails', 'Lord Voldemort’s Request', 'The Unknowable Room',
             'After the Burial', 'Horcruxes', 'Sectumsempra',
             'The Seer Overheard', 'The Cave', 'The Lightning-Struck',
             'Flight of the Prince', 'The Phoenix Lament', 'The White Tomb']
            ,
            imena_poglavij("potter6.txt")
        )


class Test07(Test):
    def test_01_besedilo(self):
        self.assertEqual("""
It was nearing midnight and the Prime Minister was sitting
alone in his office, reading a long memo that was slipping
before. He turned, very slowly, to face the empty room.
‘Hello?’ he said, trying to sound braver than he felt.
responded at once, a crisp, decisive voice that sounded as
though it were reading a prepared statement. It was coming –
as the Prime Minister had known at the first cough – from
The Prime Minister could not honestly return this compliment, so said nothing at all. He was not remotely pleased to see
Fudge, whose occasional appearances, apart from being downright alarming in themselves, generally meant that he was
about to hear some very bad news. Furthermore, Fudge was
Minister. He remembered it as though it were yesterday and
knew it would haunt him until his dying day. 
He had been standing alone in this very office, savouring
And with that, the two wizards stepped one after the other
into the bright green fire and vanished. 
Many miles away the chilly mist that had pressed against
The second woman caught the first and seized her arm, but
seemed to shine in the darkness; the long blonde hair
streaming down her back gave her the look of a drowned
person.
others and bound itself thickly around their clasped hands,
like a rope, like a fiery snake. 
Harry Potter was snoring loudly. He had been sitting
in a chair beside his bedroom window for the best part
Not Be Named was sighted once more.
‘We’re not allowed to talk about it, don’t ask me anything,’
said one agitated Obliviator, who refused to give his name as
he left the Ministry last night.
Nevertheless, highly placed sources within the Ministry
A second newspaper lay beside the first. This one bore the
headline:
SCRIMGEOUR SUCCEEDS FUDGE
Most of this front page was taken up with a large black-andwhite picture of a man with a lionlike mane of thick hair and
5 miles’. The
largely been greeted with enthusiasm by the wizarding community, though rumours of a rift between the new Minister
""".strip(), besedilo("potter6-zacetek.txt").strip())


class Test08(Test):
    def test_01_datum_rojstva_q(self):
        self.assertEqual((1965, 7, 31), datum_rojstva_q("Q34660"))
        self.assertEqual((1800, 12, 3), datum_rojstva_q("Q1031"))

    def test_02_datum_rojstva(self):
        self.assertEqual((1980, 3, 1), datum_rojstva("Ron Weasley"))
        self.assertEqual((1980, 7, 31), datum_rojstva("Harry Potter"))
        self.assertEqual((1960, 1, 30), datum_rojstva("Lily Potter"))

    def test_03_prevod_imena(self):
        self.assertEqual("Robaus Raws", prevod_imena("Severus Snape"))
        self.assertEqual("Harry Potter", prevod_imena("Harry Potter"))
        self.assertEqual("Hermiona Granger", prevod_imena("Hermione Granger"))
        self.assertEqual("Spack", prevod_imena("Kreacher"))


class Test09(Test):
    def test_00_samo_besede(self):
        self.assertEqual(
            "Hello he said trying to sound braver than he felt",
            samo_besede("‘Hello?’ he said, trying to sound braver than he felt."))
        self.assertEqual(
            "We’re not allowed to talk about it don’t ask me anything",
            samo_besede("‘We’re not allowed to talk about it, don’t ask me anything’"))

    def test_01_po_imenih(self):
        self.assertEqual(
            "Harry Ron and Ginny and also Vernon Garrick and Rosmerta walk'd down the corridor",
            po_imenih(
                "Harry, Ron and Ginny Weasley, and also Dursley, Ollivander and Rosmerta walk'd down the corridor."),
        )
        self.assertEqual(
            "Whether you call him Albus or Albus or just Albus he was a great wizard",
            po_imenih(
                "Whether you call him Albus Dumbledore, or Albus Percival Wulfric Brian Dumbledore, or just Dumbledore, he was a great wizard."),
        )
        self.assertEqual(
            "Albus was a brother of Aberforth and Ariana",
            po_imenih("Dumbledore was a brother of Aberforth Dumbledore and Ariana."),
        )
        self.assertEqual(
            "The Potters and the Dursleys were neighbours",
            po_imenih("The Potters and the Dursleys were neighbours."),
        )
        self.assertEqual(
            "Justin said Don't talk to me like this Harry",
            po_imenih("Justin Finch-Fletchley said: 'Don't talk to me like this - Potter!'"),
        )
        self.assertEqual("Island said Harry", po_imenih("'Island!' said Harry."))
        self.assertEqual("Krumberries were excellent", po_imenih("Krumberries were excellent"))

        potter6z = besedilo("potter6-zacetek.txt")
        self.assertEqual(
            "It was nearing midnight and the Prime Minister was sitting alone in his office reading a long memo that was slipping before He turned very slowly to face the empty room Hello he said trying to sound braver than he felt responded at once a crisp decisive voice that sounded as though it were reading a prepared statement It was coming as the Prime Minister had known at the first cough from The Prime Minister could not honestly return this compliment so said nothing at all He was not remotely pleased to see Cornelius whose occasional appearances apart from being downright alarming in themselves generally meant that he was about to hear some very bad news Furthermore Cornelius was Minister He remembered it as though it were yesterday and knew it would haunt him until his dying day He had been standing alone in this very office savouring And with that the two wizards stepped one after the other into the bright green fire and vanished Many miles away the chilly mist that had pressed against The second woman caught the first and seized her arm but seemed to shine in the darkness the long blonde hair streaming down her back gave her the look of a drowned person others and bound itself thickly around their clasped hands like a rope like a fiery snake Harry was snoring loudly He had been sitting in a chair beside his bedroom window for the best part Not Be Named was sighted once more We’re not allowed to talk about it don’t ask me anything said one agitated Obliviator who refused to give his name as he left the Ministry last night Nevertheless highly placed sources within the Ministry A second newspaper lay beside the first This one bore the headline SCRIMGEOUR SUCCEEDS FUDGE Most of this front page was taken up with a large black-andwhite picture of a man with a lionlike mane of thick hair and 5 miles The largely been greeted with enthusiasm by the wizarding community though rumours of a rift between the new Minister",
            po_imenih(potter6z))

        potter6 = besedilo("potter6.txt")

        rezultat = po_imenih(potter6).split()
        pricak = open("potter6-po-imenih.txt", encoding="utf-8").read().split()
        for i, (pri, po) in enumerate(zip(pricak, rezultat)):
            self.assertEqual(pri, po,
                             "\nRezultat:  " + " ".join(rezultat[max(0, i - 5):i + 5]) +
                             "\nPričakovano:" + " ".join(pricak[max(0, i - 5):i + 5]))

    def test_02_omembe(self):
        s = "Albus Dumbledore saw how Potter walked away with Ron Weasley, and Harry was saying something"

        self.assertEqual([0], omembe("Albus", s))
        self.assertEqual([3, 9], omembe("Harry", s))
        self.assertEqual([7], omembe("Ron", s))

        potter6 = besedilo("potter6.txt")
        self.assertEqual([], omembe("Hooch", potter6))
        self.assertEqual([], omembe("Fudge", potter6))
        self.assertEqual([616, 707, 720, 828, 861, 885, 952, 1004, 1009, 1068, 1143, 1344, 1377, 1497, 1558, 1591,
                          1608, 1683, 1916, 1947, 1992, 2116, 2148, 2189, 2226, 2248, 2317, 2381, 2408, 2469, 2502,
                          2542, 2581, 2632, 2656, 2675, 2688, 2767, 2832, 2890, 2922, 3027, 3130, 3192, 3249, 3337,
                          3394, 3504, 3533, 3564, 3657, 3711, 3777, 3876, 3931, 4028, 4089, 4192, 4245, 4288, 4372,
                          4480, 4519, 4961, 4973, 5061, 10459, 15671, 15731, 80629, 88120, 89189, 89469, 91559, 91570,
                          166062]
                         ,
                         omembe("Cornelius", potter6))
        self.assertEqual(2672, len(omembe("Harry", potter6)))


class Test10(Test):
    def test_01_po_blokih(self):
        potter6 = besedilo("potter6.txt")
        imena = ["Ron", "Hermione", "Ginny", "Horace", "Draco", "Albus", "Severus", "Cornelius"]
        pojavitve = po_blokih(imena, potter6, 2000)
        print(pojavitve.tolist())
        np.testing.assert_equal(
            pojavitve,
            [[0, 0, 0, 0, 0, 0, 0, 21], [0, 0, 0, 0, 0, 2, 0, 34], [0, 0, 0, 0, 0, 2, 2, 11],
             [0, 0, 0, 0, 0, 8, 34, 0], [0, 0, 0, 0, 13, 4, 36, 0], [0, 0, 0, 0, 0, 13, 0, 1],
             [0, 0, 0, 0, 0, 32, 0, 0], [0, 1, 0, 0, 0, 37, 0, 2], [0, 0, 0, 24, 0, 37, 0, 0],
             [2, 0, 0, 23, 0, 24, 0, 0], [20, 1, 0, 3, 0, 19, 3, 0], [38, 10, 7, 2, 0, 1, 0, 0],
             [36, 35, 9, 0, 0, 6, 0, 0], [33, 13, 6, 0, 0, 2, 0, 0], [24, 15, 3, 0, 10, 1, 0, 0],
             [22, 14, 9, 0, 13, 0, 0, 0], [35, 24, 3, 0, 11, 0, 0, 0], [16, 4, 4, 2, 5, 1, 0, 0],
             [1, 0, 11, 28, 6, 1, 0, 0], [4, 3, 0, 2, 27, 2, 0, 0], [8, 11, 1, 1, 3, 5, 20, 0],
             [24, 16, 0, 5, 6, 12, 4, 0], [11, 9, 0, 2, 1, 1, 25, 0], [13, 22, 0, 21, 5, 3, 1, 0],
             [9, 11, 2, 7, 7, 4, 2, 0], [0, 0, 0, 1, 0, 21, 0, 0], [0, 0, 0, 0, 0, 2, 0, 0],
             [12, 12, 0, 1, 0, 18, 0, 0], [23, 18, 2, 1, 1, 2, 0, 0], [19, 27, 1, 7, 1, 1, 5, 0],
             [21, 21, 4, 3, 3, 3, 4, 0], [19, 21, 2, 6, 0, 2, 0, 0], [16, 20, 0, 1, 14, 8, 2, 0],
             [0, 0, 0, 0, 2, 37, 1, 0], [0, 0, 0, 0, 0, 39, 0, 0], [9, 12, 0, 1, 1, 18, 0, 0],
             [30, 9, 22, 0, 0, 0, 0, 0], [44, 11, 10, 0, 3, 0, 0, 0], [32, 18, 7, 1, 1, 0, 0, 0],
             [11, 25, 3, 1, 1, 0, 1, 0], [10, 20, 1, 10, 0, 1, 5, 1], [15, 0, 2, 7, 27, 1, 22, 0],
             [27, 3, 2, 0, 6, 8, 15, 0], [30, 2, 3, 0, 0, 0, 3, 0], [11, 0, 4, 0, 0, 7, 0, 3],
             [15, 17, 3, 0, 5, 14, 5, 2], [0, 0, 0, 0, 2, 15, 2, 0], [2, 2, 0, 15, 0, 21, 0, 0],
             [16, 20, 1, 25, 1, 2, 2, 0], [9, 4, 0, 1, 15, 0, 2, 0], [45, 1, 0, 6, 6, 0, 1, 0],
             [27, 8, 10, 25, 0, 7, 0, 0], [14, 6, 2, 1, 11, 8, 11, 0], [11, 0, 6, 0, 8, 0, 1, 0],
             [16, 13, 3, 2, 4, 10, 0, 0], [3, 0, 0, 5, 0, 18, 0, 0], [0, 1, 0, 0, 0, 21, 0, 0],
             [8, 13, 0, 3, 0, 26, 3, 0], [16, 23, 0, 6, 18, 1, 2, 0], [16, 9, 0, 2, 5, 1, 12, 0],
             [26, 30, 1, 4, 6, 5, 0, 0], [18, 17, 2, 22, 7, 1, 0, 0], [2, 1, 0, 28, 0, 1, 0, 0],
             [0, 0, 0, 27, 0, 10, 0, 0], [0, 0, 0, 9, 0, 12, 0, 0], [0, 0, 0, 0, 0, 16, 0, 0],
             [12, 17, 3, 2, 0, 8, 0, 0], [13, 3, 9, 3, 16, 0, 11, 0], [7, 13, 7, 0, 3, 0, 15, 0],
             [12, 14, 14, 1, 1, 1, 8, 0], [0, 0, 0, 0, 0, 19, 10, 0], [5, 8, 1, 0, 5, 29, 7, 0],
             [0, 0, 0, 0, 0, 38, 1, 0], [1, 1, 1, 0, 0, 39, 0, 0], [0, 0, 0, 0, 0, 32, 0, 0],
             [2, 1, 0, 0, 18, 38, 5, 0], [0, 1, 0, 1, 36, 35, 2, 0], [1, 0, 2, 0, 11, 10, 21, 0],
             [0, 0, 0, 0, 0, 12, 20, 0], [11, 5, 14, 0, 6, 12, 19, 0], [21, 6, 5, 2, 1, 7, 9, 0],
             [9, 2, 2, 4, 1, 12, 2, 0], [9, 12, 4, 3, 5, 9, 9, 0], [3, 4, 10, 0, 0, 14, 0, 1]]
        )

        imena = ["Severus", "Harry", "Ron", "Hermione", "Ginny", "Horace", "Draco", "Albus", "Cornelius"]
        pojavitve = po_blokih(imena, potter6, 2000)
        try:
            from matplotlib import pyplot as plt
            fig, ax = plt.subplots()
            plt.imshow(pojavitve / np.max(pojavitve), aspect="auto")
            ax.set_xticks(np.arange(len(imena)))
            ax.set_xticklabels(imena)
            ax.set_fontsize = 6
            plt.savefig("pojavitve.png")
            plt.show()
        except Exception:
            pass

    def test_02_sovpadanje(self):
        s = "Harry and Ron met Romilda and Romilda asked Harry about Ron"
        self.assertEqual(6, sovpadanje(s, "Harry", "Ron", 2))
        self.assertEqual(4, sovpadanje(s, "Harry", "Romilda", 2))
        self.assertEqual(4, sovpadanje(s, "Romilda", "Ron", 2))

        self.assertEqual(2, sovpadanje(s, "Harry", "Ron", 1))
        self.assertEqual(1, sovpadanje(s, "Harry", "Romilda", 1))
        self.assertEqual(1, sovpadanje(s, "Romilda", "Ron", 1))

        self.assertEqual(11, sovpadanje(s, "Harry", "Ron", 3))
        self.assertEqual(8, sovpadanje(s, "Harry", "Romilda", 3))
        self.assertEqual(8, sovpadanje(s, "Romilda", "Ron", 3))

        potter6 = besedilo("potter6.txt")
        self.assertEqual(879, sovpadanje(potter6, "Cornelius", "Harry", 50))
        self.assertEqual(1164, sovpadanje(potter6, "Cornelius", "Rufus", 50))
        self.assertEqual(42245, sovpadanje(potter6, "Albus", "Harry", 50))
        self.assertEqual(48532, sovpadanje(potter6, "Harry", "Ron", 50))
        self.assertEqual(39282, sovpadanje(potter6, "Harry", "Hermione", 50))


if __name__ == "__main__":
    unittest.main()
