

import numpy as np
import unittest


class Test0(unittest.TestCase):
    def test(self):
        np.testing.assert_equal(
            ['The Other Minister', "Spinner's End", "Will and Won't",
             'Horace Slughorn'],
            naslovi[:4]
        )
        np.testing.assert_equal(
            ['The Lightning-Struck Tower', 'Flight of the Prince',
             'The Phoenix Lament', 'The White Tomb'],
            naslovi[-4:]
        )
        np.testing.assert_equal(
            [0, 1, 2, 3, 3, 4, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10,
             10, 10, 11, 11, 12, 13, 13, 13, 14, 14, 15, 15, 16, 16, 16, 17, 17,
             18, 18, 19, 19, 20, 20, 21, 22, 23, 23, 23, 24, 25, 26, 27, 28, 28,
             28, 29, 29, 29],
            poglavja[::17]
        )
        np.testing.assert_equal(
            ['Burke', 'Harry', 'Sirius', 'Dumbledore', 'Bones', 'Scrimgeour',
             'Voldemort', 'First', 'Kingsley', 'Vance', 'Fudge', 'Lestrange',
             'Lucius', 'Harry', 'Dumbledore', 'Narcissa', 'Sirius', 'Snape',
             'Voldemort', 'Draco', 'Quirrell', 'Karkaroff', 'Greyback',
             'Potter', 'Vance', 'Avery', 'Yaxley', 'Black', 'Lestrange',
             'Harry'],
            osebe[:30]
        )
        np.testing.assert_equal(
            [3, 1, 10, 4, 4, 16, 1, 1, 3, 3, 72, 36, 8, 3, 20, 46, 1,
             76, 51, 14, 1, 1, 1, 3, 1, 1, 1, 1, 6, 66],
            omembe[:30])
        np.testing.assert_equal(
            [2, 1, 5, 1, 1, 1, 1, 1, 11, 5, 7, 4, 1, 2, 1, 4, 1,
             4, 2, 2, 1, 15, 28, 2, 1, 2, 1, 1, 1, 1],
            omembe[-30:]
        )



class Test1(unittest.TestCase):
    def test_1_naj_oseba(self):
        self.assertEqual("Harry", naj_oseba())

    def test_2_naj_dogajanje(self):
        self.assertEqual(("The Cave", "Harry"), naj_dogajanje())

    def test_3_prva_omemba(self):
        self.assertEqual("The Other Minister", prva_omemba("Harry"))
        self.assertEqual("The Other Minister", prva_omemba("Sirius"))
        self.assertEqual("Spinner's End", prva_omemba("Draco"))
        self.assertEqual("Will and Won't", prva_omemba("Rosmerta"))
        self.assertEqual("Horace Slughorn", prva_omemba("Umbridge"))
        self.assertEqual("An Excess of Phlegm", prva_omemba("Ginny"))
        self.assertEqual("Snape Victorious", prva_omemba("Filch"))

    def test_4_koliko_poglavij(self):
        self.assertEqual(30, koliko_poglavij("Harry"))
        self.assertEqual(16, koliko_poglavij("Sirius"))
        self.assertEqual(17, koliko_poglavij("Draco"))
        self.assertEqual(6, koliko_poglavij("Rosmerta"))
        self.assertEqual(6, koliko_poglavij("Umbridge"))
        self.assertEqual(22, koliko_poglavij("Ginny"))

    def test_5_v_poglavjih_st(self):
        np.testing.assert_equal(
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29],
            v_poglavjih_st("Harry"))
        np.testing.assert_equal(
            [0,  1,  2,  3,  4,  5,  7, 11, 12, 15, 20, 22, 23, 24, 28, 29],
            v_poglavjih_st("Sirius"))
        np.testing.assert_equal(
            [1,  5,  6,  7, 11, 12, 13, 14, 15, 18, 19, 20, 21, 23, 24, 26, 27],
            v_poglavjih_st("Draco"))
        np.testing.assert_equal(
            [ 2, 11, 20, 24, 26, 28],
            v_poglavjih_st("Rosmerta"))
        np.testing.assert_equal(
            [ 3,  4,  6, 15, 16, 29],
            v_poglavjih_st("Umbridge"))
        np.testing.assert_equal(
            [ 4,  5,  6,  7,  8, 10, 11, 13, 14, 15, 16, 17, 18, 19, 21, 23, 24, 25, 26, 27, 28, 29],
            v_poglavjih_st("Ginny"))

    def test_6_v_poglavjih(self):
        np.testing.assert_equal(
            ["Will and Won't", 'Silver and Opals', 'The Unknowable Room',
             'The Seer Overheard', 'The Lightning-Struck Tower',
             'The Phoenix Lament'],
            v_poglavjih("Rosmerta"))

        np.testing.assert_equal(
            ['Horace Slughorn', 'An Excess of Phlegm', 'The Slug Club',
             'A Very Frosty Christmas', 'A Sluggish Memory', 'The White Tomb'],
            v_poglavjih("Umbridge"))

    def test_7_vseh_omemb(self):
        self.assertEqual(2789, vseh_omemb("Harry"))
        self.assertEqual(72, vseh_omemb("Sirius"))
        self.assertEqual(72, vseh_omemb("Draco"))
        self.assertEqual(21, vseh_omemb("Rosmerta"))
        self.assertEqual(13, vseh_omemb("Umbridge"))
        self.assertEqual(233, vseh_omemb("Ginny"))


class Test2(unittest.TestCase):
    def test_1_maska_poglavij(self):
        np.testing.assert_equal(
            [False, False, True, False, False, False, False, False, False,
             False, False, True, False, False, False, False, False, False,
             False, False, True, False, False, False, True, False, True,
             False, True, False],
            maska_poglavij("Rosmerta")
        )
        np.testing.assert_equal(
            [True, False, True, True, False, False, False, False, False,
             False, False, False, False, False, True, True, True, False,
             False, False, False, False, False, False, False, False, False,
             False, False, True],
            maska_poglavij("Fudge")
        )
        np.testing.assert_equal(
            [False, False, False, False, False, False, True, False, True,
             False, True, True, False, False, True, False, False, True,
             False, False, True, False, False, True, False, False, False,
             False, False, True],
            maska_poglavij("Crabbe")
        )

    def test_2_podobnost(self):
        self.assertAlmostEqual(0.8666666666666667, podobnost("Harry", "Ron"))
        self.assertAlmostEqual(0.9615384615384616, podobnost("Hermione", "Ron"))
        self.assertAlmostEqual(0.8888888888888888, podobnost("Crabbe", "Goyle"))
        self.assertAlmostEqual(0.34615384615384615, podobnost("Crabbe", "Ron"))
        self.assertAlmostEqual(0.08333333333333333, podobnost("Rosmerta", "Fudge"))
        self.assertAlmostEqual(0, podobnost("Rosmerta", "Umbridge"))
        self.assertAlmostEqual(0.11764705882352941, podobnost("Filch", "Fudge"))


if __name__ == "__main__":
    unittest.main()
