


import unittest
import warnings

class TestBase(unittest.TestCase):
    def setUp(self):
        warnings.simplefilter("ignore", ResourceWarning)
        self.maxDiff = None

    def assertAlmostEqualSeq(self, a, b):
        self.assertEqual(len(a), len(b))
        self.assertIs(type(a), type(b))
        for x, y in zip(a, b):
            self.assertAlmostEqual(x, y)

class Test06(TestBase):
    def test_01_preberi(self):
        self.assertEqual({'Algeria': 12170700,
 'Australia': 119374,
 'Belize': 78,
 'Brazil': 55500,
 'Brunei': 845798,
 'Canada': 379614000,
 'Chile': 84684100,
 'China': 20474700,
 'Colombia': 11564000,
 'Croatia': 24997100,
 'Cyprus': 1274570,
 'Denmark': 57819500,
 'Finland': 86144900,
 'Germany': 1378870000,
 'Greece': 42376800,
 'Hungary': 79375000,
 'Iceland': 3265010,
 'Indonesia': 4673,
 'Ireland': 54569500,
 'Japan': 777477000,
 'Kenya': 200398,
 'Korea, Rep.': 171203000,
 'Macao': 1556110,
 'Malaysia': 53326,
 'Mexico': 88531,
 'Netherlands': 201007000,
 'New Zealand': 61170600,
 'Oman': 1211080,
 'Paraguay': 6225860,
 'Peru': 19,
 'Portugal': 97218000,
 'Romania': 18805000,
 'Saudi Arabia': 143044000,
 'Serbia, FR(Serbia/Montenegro)': 22518000,
 'Singapore': 35854100,
 'South Africa': 9074,
 'Spain': 227548,
 'Sri Lanka': 19,
 'St. Lucia': 200,
 'Sweden': 161817000,
 'Switzerland': 78781300,
 'Trinidad and Tobago': 1636350,
 'Tunisia': 6075490,
 'Turkey': 111323000,
 'United Arab Emirates': 1096850,
 'United States': 3693120000}, preberi_tezo(1992))

        self.assertEqual({
            'Albania': 20438800,
            'Algeria': 274051000,
            'Andorra': 266709,
            'Angola': 430,
            'Antigua and Barbuda': 1107800,
            'Argentina': 396310000,
            'Armenia': 9875280,
            'Aruba': 3217410,
            'Australia': 307153,
            'Austria': 121018000,
            'Azerbaijan': 8954400,
            'Bahamas, The': 525098,
            'Bahrain': 12623700,
            'Bangladesh': 317,
            'Barbados': 3833010,
            'Belarus': 74475000,
            'Belgium': 763946000,
            'Benin': 826698,
            'Bermuda': 803164,
            'Bolivia': 43682,
            'Bosnia and Herzegovina': 36794300,
            'Botswana': 7766370,
            'Brazil': 4718,
            'Brunei': 3301440,
            'Bulgaria': 38975100,
            'Burkina Faso': 5084580,
            'Burundi': 12588,
            'Canada': 557569000,
            'Cape Verde': 177,
            'China': 514784000,
            'Colombia': 21095300,
            'Comoros': 8900,
            'Congo, Rep.': 88,
            'Costa Rica': 1843360,
            "Cote d'Ivoire": 24,
            'Croatia': 4016130000,
            'Cyprus': 4192850,
            'Czech Republic': 136863000,
            'Denmark': 94491200,
            'Dominican Republic': 161526,
            'Ecuador': 5594210,
            'Egypt, Arab Rep.': 1791330000,
            'El Salvador': 120787000,
            'Estonia': 12231600,
            'Eswatini': 6560520,
            'Fiji': 241,
            'Finland': 77730300,
            'France': 661362000,
            'French Polynesia': 832,
            'Gabon': 2940,
            'Gambia, The': 115011,
            'Georgia': 15231300,
            'Germany': 1365950000,
            'Ghana': 154159,
            'Greece': 140434000,
            'Greenland': 54698,
            'Grenada': 278,
            'Guatemala': 12054800,
            'Guyana': 306,
            'Hong Kong, China': 65067100,
            'Hungary': 56984000,
            'Iceland': 6159340,
            'Indonesia': 336799,
            'Iran, Islamic Rep.': 391635000,
            'Ireland': 87096000,
            'Israel': 8560,
            'Italy': 675030000,
            'Japan': 975394000,
            'Jordan': 42911000,
            'Kazakhstan': 48175900,
            'Kenya': 194185,
            'Kiribati': 1,
            'Korea, Rep.': 313604000,
            'Kuwait': 134063000,
            'Kyrgyz Republic': 13545100,
            'Latvia': 23477800,
            'Lebanon': 251538,
            'Lesotho': 384687,
            'Lithuania': 34179600,
            'Luxembourg': 4963190,
            'Macao': 3575530,
            'Malawi': 60004,
            'Malaysia': 16213400,
            'Maldives': 938743,
            'Malta': 6405490,
            'Mauritania': 3562340,
            'Mexico': 166435,
            'Micronesia, Fed. Sts.': 640,
            'Moldova': 10800300,
            'Mongolia': 2155190,
            'Montenegro': 9339400,
            'Montserrat': 615,
            'Morocco': 22467900,
            'Mozambique': 9178,
            'Myanmar': 11303,
            'Namibia': 4675770,
            'Nepal': 7701090,
            'Netherlands': 297990000,
            'New Caledonia': 1644,
            'New Zealand': 80278000,
            'Nicaragua': 8118410,
            'Niger': 4054410,
            'Nigeria': 2376620,
            'North Macedonia': 18481900,
            'Norway': 81334500,
            'Occ.Pal.Terr': 17475500,
            'Oman': 19060300,
            'Pakistan': 51772,
            'Palau': 81,
            'Paraguay': 3000,
            'Peru': 102,
            'Poland': 299034000,
            'Portugal': 141319000,
            'Qatar': 25752500,
            'Romania': 90116600,
            'Russian Federation': 1339140000,
            'Rwanda': 1419420,
            'Sao Tome and Principe': 15,
            'Saudi Arabia': 306141000,
            'Senegal': 17065500,
            'Serbia, FR(Serbia/Montenegro)': 48299100,
            'Seychelles': 1008,
            'Singapore': 47683500,
            'Slovak Republic': 54619700,
            'Slovenia': 46749400,
            'Solomon Islands': 4,
            'South Africa': 96367200,
            'Spain': 253163000,
            'Sri Lanka': 196,
            'St. Kitts and Nevis': 17451,
            'St. Lucia': 100,
            'Sudan': 27610,
            'Sweden': 181651000,
            'Switzerland': 82901000,
            'Tanzania': 986,
            'Thailand': 15267700,
            'Tonga': 1,
            'Trinidad and Tobago': 9039110,
            'Tunisia': 17553500,
            'Turkey': 534202000,
            'Uganda': 183170,
            'Ukraine': 265648000,
            'United Arab Emirates': 142501000,
            'United Kingdom': 1169560000,
            'United States': 4868130000,
            'Uruguay': 45742600,
            'Vietnam': 152365,
            'Zambia': 828014}, preberi_tezo(2013))

        self.assertEqual(
            {'Argentina': 53115280.0,
             'Australia': 31130.0,
             'Bhutan': 4910.0,
             'Brazil': 23270.0,
             'Brunei': 439910.0,
             'Canada': 169924580.0,
             'Chile': 35049860.0,
             'China': 7738950.0,
             'Colombia': 785500.0,
             'Congo, Rep.': 320.0,
             'Croatia': 9469840.0,
             'Czech Republic': 45726850.0,
             'Denmark': 24048990.0,
             'Dominica': 40.0,
             'Finland': 54769630.0,
             'Gabon': 780.0,
             'Germany': 615356990.0,
             'Greece': 33888240.0,
             'Guatemala': 30000.0,
             'Hong Kong, China': 19934540.0,
             'Hungary': 18034000.0,
             'Iceland': 2811190.0,
             'Indonesia': 127360.0,
             'Ireland': 20753690.0,
             'Japan': 475253890.0,
             'Korea, Rep.': 56641070.0,
             'Macao': 586100.0,
             'Malaysia': 9380.0,
             'Mexico': 23000.0,
             'Morocco': 1400.0,
             'Netherlands': 113795170.0,
             'New Zealand': 30820660.0,
             'Nicaragua': 1729430.0,
             'Norway': 36343830.0,
             'Oman': 442640.0,
             'Paraguay': 663460.0,
             'Portugal': 69261980.0,
             'Romania': 10049050.0,
             'Saudi Arabia': 62058530.0,
             'Singapore': 11639890.0,
             'South Africa': 66770.0,
             'Spain': 48490010.0,
             'St. Kitts and Nevis': 33630.0,
             'St. Lucia': 190.0,
             'St. Vincent and the Grenadines': 3540.0,
             'Sweden': 89521210.0,
             'Switzerland': 64723880.0,
             'Thailand': 1410.0,
             'Trinidad and Tobago': 223710.0,
             'Tunisia': 2565840.0,
             'Turkey': 41710700.0,
             'United Arab Emirates': 1470530.0,
             'United Kingdom': 394860960.0,
             'United States': 1305456900.0}, preberi_vrednost(1993))

    def test_02_najcenejse_banane(self):
        drzava, cena = najcenejse_banane(2023)
        self.assertEqual("Burkina Faso", drzava)
        self.assertAlmostEqual(0.016667700370582853, cena)

        drzava, cena = najcenejse_banane(2001)
        self.assertEqual("Burkina Faso", drzava)
        self.assertAlmostEqual(0.03806840620811682, cena)

        drzava, cena = najcenejse_banane(2002)
        self.assertEqual("Costa Rica", drzava)
        self.assertAlmostEqual(0.02951126062984768, cena)

    def test_03_najblizje_sloveniji(self):
        self.assertEqual("Kuwait", najblizje_sloveniji(2000))
        self.assertEqual("Kuwait", najblizje_sloveniji(2001))
        self.assertEqual("Belarus", najblizje_sloveniji(2002))
        self.assertIsNone(najblizje_sloveniji(1992))
        self.assertIsNone(najblizje_sloveniji(1993))
        self.assertEqual("Lithuania", najblizje_sloveniji(1994))

    def test_04_razpon_cen(self):
        self.assertAlmostEqualSeq((0.016667700370582853, 30.217391304347824), razpon_cen(2023))
        self.assertAlmostEqualSeq((0.02951126062984768, 35.0), razpon_cen(2002))


class Test07(TestBase):
    def test_01_naj_uvoznice(self):
        self.assertEqual(
            ['United States', 'China', 'Germany', 'Netherlands', 'Japan'],
            naj_uvoznice(2023, 5))
        self.assertEqual(
            ['United States', 'China'],
            naj_uvoznice(2023, 2))
        self.assertEqual(
            ['United States', 'China', 'Germany', 'Netherlands', 'Japan',
             'Italy', 'France', 'Canada', 'Poland', 'Spain'],
            naj_uvoznice(2023, 10))
        self.assertEqual(
            ['United States', 'China', 'Germany', 'Japan', 'Netherlands',
             'France', 'Italy', 'Iran, Islamic Rep.', 'Canada', 'Argentina'],
            naj_uvoznice(2022, 10))
        self.assertEqual(
            ['United States', 'Germany', 'Japan'],
            naj_uvoznice(2000, 3))

    def test_02_izpis(self):
        self.assertEqual("""Slovenia           98   0.79
China            1768   0.61
Germany          1367   0.85
Netherlands      1072   0.85
Japan            1033   0.93""",
            izpis(["Slovenia", "China", "Germany", "Netherlands", "Japan"], 2023).strip("\n"))

    def test_03_prvih_n(self):
        self.assertEqual("""United States    3693   0.36
Germany          1378   0.57
Japan             777   0.67
Canada            379   0.44
Netherlands       201   0.54
Korea, Rep.       171   0.47
Sweden            161   0.61
Saudi Arabia      143   0.36
Turkey            111   0.25
Portugal           97   0.26""",
                         prvih_n(1992, 10).strip("\n"))

        self.assertEqual("""United States    5091   0.62
China            1768   0.61
Germany          1367   0.85
Netherlands      1072   0.85
Japan            1033   0.93
Italy             844   0.74
France            824   1.05
Canada            615   0.82
Poland            494   0.76
Spain             481   0.77""",
                         prvih_n(2023, 10).strip("\n"))


class Test08(TestBase):
    def test_01_trend(self):
        self.assertEqual(
            [None, None, 25227100, 31298100, 29645500, 30287800, 25391200, 28693400, 26674200,
             26664600, 28098000, 33809900, 41158800, 47687200, 35354800, 42689100, 59178400,
             69266700, 53954900, 67476400, 39476500, 46749400, 58085400, 72154400, 73737800,
             71087300, 78777200, 91765000, 116509000, 114574000, 123048000, 98173100],
            trend("Slovenia", 1992, 2023))

        self.assertEqual(
            [1073860000, 770850000, 1039140000, 1544820000, 1939970000, 1764340000],
            trend("China", 2015, 2020))

    def test_02_skupni_uvoz(self):
        self.assertEqual(7829944158, skupni_uvoz(1992))
        self.assertEqual(9055484992, skupni_uvoz(1993))
        self.assertEqual(18326286060, skupni_uvoz(2023))

    def test_03_rast_porabe(self):
        self.assertEqual([12499315869,
 12150737601,
 12876667524,
 13476760138,
 13311378540,
 13608018907,
 16741421577,
 17330617831,
 16229139850,
 17055847086,
 18133232727],
                         rast_porabe(2000, 2010))

    def test_04_inflacija(self):
        self.assertAlmostEqualSeq(
            [0.6738503991609981,
             0.6809512139492303,
             0.6742437705078757,
             0.6855178768269456,
             0.6806523075526903,
             0.6769034579795189],
            inflacija(2015, 2020))
        self.assertAlmostEqualSeq(
            [0.6769034579795189, 0.6892200295239537, 0.7527776871788754, 0.8208387799224389],
            inflacija(2020, 2023))
        self.assertAlmostEqualSeq(
            [0.4551290760303785,
             0.4340479403888785,
             0.4912764163527277,
             0.5294995756358607,
             0.5211428398147174,
             0.49504904182201176,
             0.49917266781740505,
             0.4681445898191336,
             0.46244905085852905,
             0.4786728527098904,
             0.5031545559380399,
             0.5457046660096905,
             0.6130420403475356,
             0.6463971390776964,
             0.5430989804647938,
             0.5967451634355989,
             0.7502147946553064,
             0.6937984323108277,
             0.6359469331041802,
             0.6814821244145716,
             0.6922799408846333,
             0.5519020780710178,
             0.7151778439910942,
             0.6738503991609981,
             0.6809512139492303,
             0.6742437705078757,
             0.6855178768269456,
             0.6806523075526903,
             0.6769034579795189,
             0.6892200295239537,
             0.7527776871788754,
             0.8208387799224389],
            inflacija(1992, 2023))


class Test09(TestBase):
    def test_01_tabela(self):
        tabela(1992, 2000, ["Slovenia", "Germany", "Japan", "United States"], "my-file1.txt")
        with open("my-file1.txt") as f, open("test1.txt") as g:
            self.assertEqual(g.read().strip("\n"), f.read().rstrip("\n"))

        tabela(2000, 2010, ["Croatia", "Mexico"], "my-file2.txt")
        with open("my-file2.txt") as f, open("test2.txt") as g:
            self.assertEqual(g.read().strip("\n"), f.read().rstrip("\n"))

        tabela(1992, 2020, ["Croatia", "Mexico", "Slovenia", "Germany", "Japan", "United States", "Peru", "Spain", "Turkey"], "my-file3.txt")
        with open("my-file3.txt") as f, open("test3.txt") as g:
            self.assertEqual(g.read().strip("\n"), f.read().rstrip("\n"))


class Test10(TestBase):
    def test_01_tabela_drzav(self):
        tabela_drzav(1992, 2000, ["Slovenia", "Germany", "Japan", "United States"], "my-file-d1.txt")
        with (open("my-file-d1.txt", encoding="utf-8") as f,
              open("test-d1.txt", encoding="utf-8") as g):
            self.assertEqual(g.read().strip("\n"), f.read().rstrip("\n"))

        tabela_drzav(2000, 2010, ["Croatia", "Mexico"], "my-file-d2.txt")
        with (open("my-file-d2.txt", encoding="utf-8") as f,
              open("test-d2.txt", encoding="utf-8") as g):
            self.assertEqual(g.read().strip("\n"), f.read().rstrip("\n"))

        tabela_drzav(1992, 2020, ["Croatia", "Mexico", "Slovenia", "Germany", "Japan", "United States", "Peru", "Spain", "Turkey"], "my-file-d3.txt")
        with (open("my-file-d3.txt", encoding="utf-8") as f,
              open("test-d3.txt", encoding="utf-8") as g):
            self.assertEqual(g.read().strip("\n"), f.read().rstrip("\n"))


if __name__ == "__main__":
    unittest.main()
