import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

/**
 *
 * @author tomaz
 */
public class ClassDump {
  
  
  static String[] imena = {
    /*0*/   "/undefined/        ",
    /*1*/ 	"Utf8               ",  // 2(len) + 2*len
    /*2*/   "/undefined         ",
    /*3*/ 	"Integer            ",  // 4
    /*4*/ 	"Float              ",  // 4
    /*5*/ 	"Long               ",  // 4 + 4
    /*6*/ 	"Double             ",  // 4 + 4
    /*7*/ 	"Class              ",  // 2
    /*8*/ 	"String             ",  // 2
    /*9*/ 	"Fieldref           ",  // 2 + 2
    /*10*/ 	"Methodref          ",  // 2 + 2
    /*11*/ 	"InterfaceMethodref ",  // 2 + 2
    /*12*/ 	"NameAndType        "   // 2 + 2
  };


  public static String readBytes(InputStream in, int n) throws Exception {
    byte prebrano[] = new byte[n];
    in.read(prebrano);

    String result="";
    for(int i=0; i<n; i++)
      result += String.format("%02X ", prebrano[i]);
    return result;
  }

  public static int readShort(InputStream in) throws Exception {
    return (in.read() << 8) + in.read();
  }


  
public static void main(String args[]) throws Exception {
    String className = args[0];

    try (FileInputStream fis = new FileInputStream(new File(className))) {
      
      String magic = readBytes(fis, 4);
      String minor = readBytes(fis, 2);
      String major = readBytes(fis, 2);
      
      System.out.println("Magic:   " + magic);
      System.out.println("Minor:   " + minor);
      System.out.println("Major:   " + major);
     
      int cpNum = readShort(fis);
      System.out.println("Stevilo vnosov v naboru konstant: " + cpNum);
      
      for (int i = 0; i < cpNum-1; i++) {
        int tag = fis.read();
        System.out.printf("%3d %s: ", i+1, imena[tag]);
        
        switch (tag){
          case 1:
            int len = readShort(fis);
            for (int j = 0; j < len; j++) {
              System.out.print((char) fis.read());
            }
            break;
          case 3: case 4:
            System.out.print("(bytes): " + readBytes(fis, 4));
            break;
          case 5: case 6:
            System.out.print("(bytes): " + readBytes(fis, 8));
            i++;
            break;
          case 7: case 8:
            System.out.print("#" + readShort(fis));
            break;
          case 9: case 10: case 11: case 12:
            System.out.printf("#%d, #%d", readShort(fis), readShort(fis));
            break;
          default:
            System.out.println("NAPAKA!");
            System.exit(0);
        }
        System.out.println("");
      }
     
      
    } catch (FileNotFoundException e) {
      System.out.println("Napaka: " + e);
    }
  }

}
